#include "threaded_executor.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NYasm::NCommon;

Y_UNIT_TEST_SUITE(ThreadedExecutorTest) {
    Y_UNIT_TEST(TestFailed) {
        auto future(TThreadedExecutor::Get().Add([]() {
            ythrow yexception() << "failed";
        }));
        UNIT_ASSERT_EXCEPTION(future.GetValue(TDuration::Max()), yexception);
    }

    Y_UNIT_TEST(TestSuccess) {
        TAtomic flag = 0;
        auto future(TThreadedExecutor::Get().Add([&]() {
            AtomicSet(flag, 1);
            return;
        }));
        future.GetValue(TDuration::Max());
        UNIT_ASSERT(AtomicGet(flag));
    }
}
