"""
    Various tags related errors.
"""


class TagsError(Exception):
    str_format = "Error"

    def __init__(self, ctx, *args):
        self.attrs = []
        self.ctx = ctx

        for name, value in args:
            self.attrs.append(name)
            setattr(self, name, value)

    def __repr__(self):
        return "{0}(ctx={1!r}, {2})".format(
            self.__class__.__name__,
            self.ctx,
            ", ".join("{0}={1!r}".format(k, getattr(self, k)) for k in self.attrs)
        )

    def __str__(self):
        return "{0}, ctx: {1!r}".format(self.str_format.format(**self.__dict__), self.ctx)


class InvalidTagSet(TagsError):
    str_format = "{number_of_tags} is invalid number of tags for underscored or histdb something format"

    def __init__(self, key, number_of_tags):
        super(self.__class__, self).__init__(key, ("number_of_tags", number_of_tags))


class ArgumentTypeError(TagsError):
    str_format = "Argument must be a {expected} instead of {type.__name__}"

    def __init__(self, raw, type, expected):
        super(self.__class__, self).__init__(raw, ("type", type), ("expected", expected))


class ArgumentUnicodeError(TagsError):
    str_format = "'ascii' codec can't encode argument"


class ItypeError(TagsError):
    str_format = "Itype '{itype}' doesn't match restrictions"

    def __init__(self, raw, itype):
        super(self.__class__, self).__init__(raw, ("itype", itype))


class EmptyItype(TagsError):
    str_format = "Empty itype"


class ItypeTypeError(TagsError):
    str_format = "Itype name must be a str instead of {type.__name__}"

    def __init__(self, raw, type):
        super(self.__class__, self).__init__(raw, ("type", type))


class TagNameError(TagsError):
    str_format = "Tag name '{tag}' doesn't match restrictions"

    def __init__(self, raw, tag):
        super(self.__class__, self).__init__(raw, ("tag", tag))


class EmptyTagName(TagsError):
    str_format = "Empty tag name"


class MissingTagNameTagValuesSeparator(TagsError):
    str_format = "Missing a separator between tag name and tag value"


class TagValueError(TagsError):
    str_format = "Tag value '{value}' doesn't match restrictions"

    def __init__(self, raw, value):
        super(self.__class__, self).__init__(raw, ("value", value))


class EmptyTagValue(TagsError):
    str_format = "Empty tag value for tag '{tag_name}'"

    def __init__(self, raw, tag_name):
        super(self.__class__, self).__init__(raw, ("tag_name", tag_name))


class MissingItype(TagsError):
    str_format = "Missing itype"


class MultipleItypeValues(TagsError):
    str_format = "Multiple values for itype tag: '{values}'"

    def __init__(self, raw, values):
        super(self.__class__, self).__init__(raw, ("values", values))


class TagMeetsTwice(TagsError):
    def __init__(self, raw, tag_name):
        super(self.__class__, self).__init__(raw, ("tag_name", tag_name))
    str_format = "Tag {tag_name} defined twice"


class ItypeMeetsTwice(TagsError):
    str_format = "Itype defined twice"


class TagsIsNotDict(TagsError):
    str_format = "tags should be dictionary"
