import math

from collections import namedtuple
from itertools import izip

MIN_PERIOD = 5

TimeSeries = namedtuple("TimeSeries", [
    "values",
    "start_ts",
    "period"
])


def adjust_timestamp(ts, period):
    return int(ts - (ts % period))


def parse_proto_timeseries_with_range(proto_ts, st, et, period):
    """
    Build TimeSeries for proto timeseries and range.
    :param proto_ts: proto message from solomon gateway response.
    :param st: start time in seconds
    :param et: end time in seconds (not included)
    :param period: period in seconds
    :return: TimeSeries
    """
    values = [None] * ((et - st) / period)
    for ts_ms, value in izip(proto_ts.timestamps_millis, proto_ts.values):
        if math.isnan(value) or math.isinf(value):
            continue
        value_idx = (adjust_timestamp(int(ts_ms / 1000), period) - st) / period
        if 0 <= value_idx < len(values):
            values[value_idx] = value
    return TimeSeries(values, st, period)


class cached_property(object):

    def __init__(self, func):
        self.func = func

    def __get__(self, instance, owner):
        if instance is None:
            return self
        name = self.func.__name__
        if name.startswith("__") and not name.endswith("__"):
            name = "_{0}{1}".format(owner.__name__, name)
        res = instance.__dict__[name] = self.func(instance)
        return res


class AnyArgs(object):
    def __init__(self):
        pass
