# All functions allowed in yasm expressions. Originally was collected from AutoHandler-derived classes
FUNCS = [
    {
        "name": "abs",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "aver",
        "normalizable": False,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "ceil",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "const",
        "normalizable": False,
        "args": [
            {
                "name": "value",
                "types": ["number"]
            },
            {
                "name": "dimension",
                "types": ["number"],
                "optional": True,
                "vars": [
                    {"name": "Ki", "desc": "2 ^ 10"},
                    {"name": "Mi", "desc": "2 ^ 20"},
                    {"name": "Gi", "desc": "2 ^ 30"},
                    {"name": "Ti", "desc": "2 ^ 40"},
                    {"name": "Pi", "desc": "2 ^ 50"},
                    {"name": "u", "desc": "10 ^ -6"},
                    {"name": "m", "desc": "10 ^ -3"},
                    {"name": "c", "desc": "10 ^ -2"},
                    {"name": "d", "desc": "10 ^ -1"},
                    {"name": "k", "desc": "10 ^ 3"},
                    {"name": "M", "desc": "10 ^ 6"},
                    {"name": "G", "desc": "10 ^ 9"},
                    {"name": "T", "desc": "10 ^ 12"}
                ]
            }
        ]
    },
    {
        "name": "conv",
        "normalizable": True,
        "args": [
            {
                "name": "signal",
                "types": ["signal"]
            },
            {
                "name": "from/to",
                "types": ["number"],
                "vars": [
                    {"name": "Ki", "desc": "2 ^ 10"},
                    {"name": "Mi", "desc": "2 ^ 20"},
                    {"name": "Gi", "desc": "2 ^ 30"},
                    {"name": "Ti", "desc": "2 ^ 40"},
                    {"name": "Pi", "desc": "2 ^ 50"},
                    {"name": "u", "desc": "10 ^ -6"},
                    {"name": "m", "desc": "10 ^ -3"},
                    {"name": "c", "desc": "10 ^ -2"},
                    {"name": "d", "desc": "10 ^ -1"},
                    {"name": "k", "desc": "10 ^ 3"},
                    {"name": "M", "desc": "10 ^ 6"},
                    {"name": "G", "desc": "10 ^ 9"},
                    {"name": "T", "desc": "10 ^ 12"}
                ]
            },
            {
                "name": "to",
                "types": ["number"],
                "optional": True,
                "vars": [
                    {"name": "Ki", "desc": "2 ^ 10"},
                    {"name": "Mi", "desc": "2 ^ 20"},
                    {"name": "Gi", "desc": "2 ^ 30"},
                    {"name": "Ti", "desc": "2 ^ 40"},
                    {"name": "Pi", "desc": "2 ^ 50"},
                    {"name": "u", "desc": "10 ^ -6"},
                    {"name": "m", "desc": "10 ^ -3"},
                    {"name": "c", "desc": "10 ^ -2"},
                    {"name": "d", "desc": "10 ^ -1"},
                    {"name": "k", "desc": "10 ^ 3"},
                    {"name": "M", "desc": "10 ^ 6"},
                    {"name": "G", "desc": "10 ^ 9"},
                    {"name": "T", "desc": "10 ^ 12"}
                ]
            }
        ]
    },
    {
        "name": "count",
        "normalizable": False,
        "args": [
            {
                "name": "signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "diff",
        "normalizable": True,
        "args": [
            {
                "name": "minuend",
                "types": ["signal"]
            },
            {
                "name": "subtrahend",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "div",
        "normalizable": False,
        "args": [
            {
                "name": "nominator",
                "types": ["signal"]
            },
            {
                "name": "denominator",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "exp",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "floor",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "fract",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "havg",
        "normalizable": False,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"]
            },
            {
                "name": "fallback-signal",
                "types": ["signal"],
                "optional": True
            }
        ]
    },
    {
        "name": "hcount",
        "normalizable": True,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"]
            },
            {
                "name": "start",
                "types": ["number"],
                "optional": True,
                "vars": ["inf"]
            },
            {
                "name": "end",
                "types": ["number"],
                "optional": True,
                "vars": ["inf"]
            }
        ]
    },
    {
        "name": "hmerge",
        "normalizable": True,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "hperc",
        "normalizable": False,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"]
            },
            {
                "name": "start",
                "types": ["number"],
                "optional": True,
                "vars": ["inf"]
            },
            {
                "name": "end",
                "types": ["number"],
                "optional": True,
                "vars": ["inf"]
            }
        ],
    },
    {
        "name": "hsum",
        "normalizable": True,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "max",
        "normalizable": False,
        "args": [
            {
                "name": "signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "min",
        "normalizable": False,
        "args": [
            {
                "name": "signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "mul",
        "normalizable": True,
        "args": [
            {
                "name": "signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "na",
        "normalizable": True,
        "args": [
            {
                "name": "signal",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "neg",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "normal",
        "normalizable": False,
        "args": []
    },
    {
        "name": "or",
        "normalizable": False,
        "args": [
            {
                "name": "signal",
                "types": ["signal"]
            },
            {
                "name": "fallback",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "perc",
        "normalizable": False,
        "args": [
            {
                "name": "nominator",
                "types": ["signal"]
            },
            {
                "name": "denominator",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "quant",
        "normalizable": False,
        "args": [
            {
                "name": "hgram-signal",
                "types": ["signal"]
            },
            {
                "name": "quantile",
                "types": ["number"],
                "vars": ["min", "med", "max"]
            },
            {
                "name": "fallback-signal",
                "types": ["signal"],
                "optional": True
            }
        ]
    },
    {
        "name": "random",
        "normalizable": False,
        "args": []
    },
    {
        "name": "round",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "sqrt",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    },
    {
        "name": "sum",
        "normalizable": True,
        "args": [
            {
                "name": "signal",
                "types": ["signal"],
                "repeat": {"max": "inf", "min": 1}
            }
        ]
    },
    {
        "name": "trunc",
        "normalizable": True,
        "args": [
            {
                "name": "value",
                "types": ["signal"]
            }
        ]
    }
]
