import logging


class RequestLoggerFormatter(logging.Formatter):
    REQUEST_ID_FIELD = "request_id"
    DEFAULT_FORMAT = "%(asctime)s %(levelname)s (%(module)s) %(message)s"
    REQUEST_ID_FORMAT = "%(asctime)s %(levelname)s [%(request_id)s] (%(module)s) %(message)s"

    def __init__(self):
        super(RequestLoggerFormatter, self).__init__(self.DEFAULT_FORMAT)
        self._request_formatter = logging.Formatter(self.REQUEST_ID_FORMAT)

    def format(self, record):
        request_id = getattr(record, self.REQUEST_ID_FIELD, None)
        if request_id is not None:
            return self._request_formatter.format(record)
        return super(RequestLoggerFormatter, self).format(record)


class RequestLoggerAdapter(logging.LoggerAdapter):

    def __init__(self, base_logger, request_id):
        extra = {
            RequestLoggerFormatter.REQUEST_ID_FIELD: request_id
        }
        super(RequestLoggerAdapter, self).__init__(base_logger, extra)
