import time
from contextlib import contextmanager

TIMING_INTERVALS_LOG_1_3 = [0.0] + [1.3 ** x for x in xrange(-10, 40)]


@contextmanager
def time_it(metric_name, unistat):
    start_time = time.time()
    try:
        yield
    finally:
        if unistat is not None:
            unistat.push(metric_name, time.time() - start_time)
