import re

MAX_NUMBER_OF_TAGS = 11

#: correct tag name, e.g. igroup, service, itype, ctype, prj, geo, tier
is_correct_tag_name = re.compile(r"^[a-z][0-9a-z_]{1,31}\Z").match

#: correct tag value, e.g test, SAS_YASM_YASMTESTIT_UNSTABLE, unstable_yasm_testit
is_correct_tag_value = re.compile(r"^[a-zA-Z0-9@._][a-zA-Z0-9-@._]{0,127}\Z").match

#: stricter regex for itype to be able to write it to stockpile (https://st.yandex-team.ru/GOLOVAN-6591)
is_correct_itype_value = re.compile(r"^[a-zA-Z0-9_][a-zA-Z0-9-_]{0,40}\Z").match

# correct tags format for user requests, with * placeholder
is_correct_request_tag_value = re.compile(r"^[a-zA-Z0-9@._*][a-zA-Z0-9-@._*]{0,127}\Z").match


# we can't exclude minus sign from signal name because there are many
# signals with minus (see balancer_report module for example)
# also forbid _avvx, _avvn and _avvt
def is_correct_signal(x):
    return re.compile(r"^[a-zA-Z0-9_\-./@]{1,128}\Z").match(x) and not re.compile(r".+_[xnta]vv[xnt]\Z").match(x)


ALERT_NAME_REGEX = r"[a-zA-Z0-9@+-./_]{1,128}"
is_juggler_host_correct_re = re.compile(
    r"""^(?:(?:[a-zA-Z0-9]|[-a-zA-Z0-9][\w\-]*[a-zA-Z0-9])\.)*
        (?:[a-zA-Z0-9]|[-a-zA-Z0-9][\w\-]*[a-zA-Z0-9])\Z""",
    re.X)
is_juggler_service_correct_re = re.compile(r"^[\w\-+=./]{1,128}\Z", re.X)
