import json
import logging

log = logging.getLogger(__name__)


class YasmConfLite(object):
    """
    Light version of a full YasmConf in bitbucket.
    Essentially a light wrapper over a parsed yasm.conf json.
    """
    def __init__(self, path=None, conf=None):
        self.conf = {}
        self.load(path, conf)

    def load(self, path=None, conf=None):
        if conf is not None:
            self.conf = conf
        else:
            try:
                with open(path, 'r') as f:
                    self.conf = json.loads(f.read())
            except Exception:
                log.exception("Could not load config at {}".format(path))
                raise

    def required_tags(self, itype):
        cnf = self._get_tagkey_conf(itype)
        return cnf.get("required", [])

    def get_conflist(self):
        return self.conf["conflist"]

    def _get_tagkey_conf(self, itype):
        try:
            return self.get_conflist()[itype]['tagkeys']
        except KeyError:
            return {}
