#pragma once

#include <infra/yasm/histdb/components/formats/something.h>
#include <infra/yasm/common/labels/signal/signal_name.h>

#include <util/generic/string.h>
#include <util/generic/xrange.h>
#include <util/stream/file.h>
#include <library/cpp/on_disk/aho_corasick/reader.h>
#include <library/cpp/on_disk/aho_corasick/writer.h>

namespace NCleaner {
    class TFilter {
    public:
        TFilter(const TVector<TString>& prefixes, const TString& excludedFile, bool backup);

        const TString& GetHeaderSuffix() {
            return HeaderSuffix;
        }

        void Start(const TStringBuf chunkPath);

    private:
        const TVector<TString> Prefixes;
        const bool Backup;
        THolder<TDefaultMappedAhoCorasick> ExcludedSearcher;

        const std::array<char, 4> CurrentVersion{{1, 0, 0, 0}};

        static constexpr size_t VersionOffset{sizeof(ui32)};

        const TString HeaderSuffix{".header"};
        const TString DataSuffix{".data"};
        const TString TempSuffix{".cleaner_temp"};
        const TString BackupSuffix{".backup"};

        void CleanChunk(
            NHistDb::TSomethingFormat& inputFormat,
            NHistDb::TSnappyFile& inputData,
            NHistDb::TSnappyFile& outputData,
            TFileOutput& outputHeaderFile);

        bool MatchSignalPrefix(const TString& signalName) const;
    };
}
