#pragma once

#include "chunk_cleaner.h"

#include <re2/re2.h>

namespace NCleaner {
    class THistdbCleaner {
    public:
        THistdbCleaner(
            const TString& histdbPath,
            const TStringBuf groupRegex,
            const TStringBuf chunkRegex,
            const TVector<TString>& prefixes,
            const TString& excludedFile,
            int threadCount,
            bool backup
        );

        void Start();

    private:
        TFilter Filter;
        const TString HistdbPath;
        const re2::RE2 GroupRegex;
        const re2::RE2 ChunkRegex;
        const int ThreadCount;
    };
}
