#include <infra/yasm/histdb/components/placements/second.h>

#include <library/cpp/getopt/last_getopt.h>

#include <util/generic/yexception.h>

using namespace NLastGetopt;
using namespace NHistDb;

int main(int argc, const char** argv) {
    TOpts options{TOpts::Default()};

    TString optHistdbPath;
    options
        .AddCharOption('d', "histdb path")
        .AddLongName("histdb")
        .RequiredArgument("DIR")
        .Required()
        .StoreResult(&optHistdbPath);

    TString optHostName;
    options
        .AddCharOption('n', "host name")
        .AddLongName("hostname")
        .RequiredArgument("HOST")
        .Required()
        .StoreResult(&optHostName);

    TString optPeriod;
    options
        .AddCharOption('p', "period name")
        .AddLongName("period")
        .RequiredArgument("PERIOD")
        .Required()
        .StoreResult(&optPeriod);

    ui64 optStartTime;
    options
        .AddCharOption('t', "start time")
        .AddLongName("start-time")
        .RequiredArgument("TIME")
        .Required()
        .StoreResult(&optStartTime);

    options.AddHelpOption('h');
    options.AddVersionOption('v');

    TOptsParseResult optParsing(&options, argc, argv);

    try {
        const TRecordPeriod period(TRecordPeriod::Get(optPeriod));
        const TInstant startTime(period.GetStartTime(TInstant::Seconds(optStartTime)));
        Cerr << "compacting root=" << optHistdbPath << " host=" << optHostName << " period=" << period.GetResolution() << " start=" << startTime << Endl;

        TSecondPlacementWriter writer(optHistdbPath, optHostName, period, startTime);
        writer.Compact();
        writer.Dump();
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
}
