#pragma once

#include <util/generic/string.h>
#include <infra/yasm/histdb/dumper/lib/metrics.h>

namespace NHistDb {
    namespace NMetrics {
        const TString UPLOAD_CLEAR_KEY= "history_uploader.clear_one_key";
        const TString UPLOAD_CLEAR_PERC = "history_uploader.clear_perc";

        const TString UPLOAD_HOST_DATA_TIME = "history_uploader.upload_host_time";
        const TString UPLOAD_PERIOD_DATA_TIME = "history_uploader.upload_period_time";
        const TString UPLOAD_CHUNK_DATA_TIME = "history_uploader.upload_chunk_time";
        const TString UPLOAD_CHUNKS_COUNT = "history_uploader.chunks_upload";

        const TString UPLOAD_TOTAL_KEYS = "history_uploader.total_tags";
        const TString UPLOAD_UNAGGREGATED_KEYS = "history_uploader.unaggregated_tags";
        const TString UPLOAD_IGNORED_KEYS = "history_uploader.ignored_tags";

        const TString UPLOAD_IGNORED_ROWS = "history_uploader.ignored_row";
        const TString UPLOAD_UNAGGREGATED_ROWS = "history_uploader.unaggregated_row";
        const TString UPLOAD_DUMPED_ROWS = "history_uploader.dumped_row";

        const TString UPLOAD_STAT_PERC = "history_uploader.state_in_perc";
        const TString UPLOAD_DUMPED_BYTES = "history_uploader.dumped_bytes";
        const TString UPLOAD_TOTAL_BYTES = "history_uploader.total_bytes";

        class THistoryUploaderStatsInitializer final: public NMonitoring::TStatsInitializer {
        public:
            void Init(TUnistat& creator) const {
                TDumperStatsInitializer statsInitializer;
                statsInitializer.Init(creator);
                auto five_percent_intervals = GetLinearWeights(0, 100, 5);

                DrillHistogramHole(creator, NMetrics::UPLOAD_CLEAR_PERC, five_percent_intervals);
                DrillHistogramHole(creator, NMetrics::UPLOAD_STAT_PERC, five_percent_intervals);
                DrillAmmxHole(creator, NMetrics::UPLOAD_DUMPED_BYTES);
                DrillAmmxHole(creator, NMetrics::UPLOAD_TOTAL_BYTES);
            };
        };
    } // namespace NMetrics
} // namespace NHistDb
