#pragma once

#include <infra/yasm/stockpile_client/settings.h>

#include <infra/monitoring/common/settings.h>
#include <infra/yasm/histdb/components/placements/periods.h>

namespace NHistDb {
    class THistoryUploaderSettings final: public NMonitoring::TSettings {
    public:
        inline const TFsPath& GetRoot() const {
            return Root;
        }

        inline const TString& GetTags() const {
            return Tags;
        }

        inline const TFsPath& GetRulesPath() const {
            return RulesPath;
        }

        inline bool GetReadOnly() const {
            return ReadOnly;
        }

        inline size_t GetThreadsCount() const {
            return ThreadsCount;
        }

        inline const NStockpile::TSettings GetStockpileSettings() const {
            return StockpileSettingsFactory.CreateStockpileSettings(true);
        }

        void ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed);
        static void FillParser(NLastGetopt::TOpts& options);

        inline TMaybe<TString> GetTestPeriod() const {
            return Period;
        }

        inline TMaybe<TString> GetTestItype() const {
            return Itype;
        }

        inline TMaybe<TString> GetStatePath() const {
            return StatePath;
        }

        inline TInstant GetEnd() const {
            return End;
        }

        inline TMaybe<TInstant> GetBegin() const {
            return Begin;
        }

        inline TString GetLogFileStockpile() const {
            return LogFileStockpile;
        }

    private:
        inline void SetPeriod(TStringBuf value) {
            Period = value;
        }

        inline void SetItype(TStringBuf value) {
            Itype = value;
        }

        inline void SetRulesPath(TStringBuf value) {
            RulesPath = value;
        }

        inline void SetRoot(TStringBuf value) {
            Root = value;
        }

        inline void SetTags(TStringBuf value) {
            Tags = TString{value};
        }

        inline void SetReadOnly(bool value) {
            ReadOnly = value;
        }

        inline void SetThreadsCount(size_t value) {
            ThreadsCount = value;
        }

        inline void SetStatePath(TStringBuf value) {
            StatePath = value;
        }

        inline void SetEnd(size_t value) {
            const auto& period = NHistDb::TRecordPeriod::Get("h");
            End = period.GetPointStartTime(TInstant::Seconds(value));
        }

        inline void SetBegin(size_t value) {
            const auto& period = NHistDb::TRecordPeriod::Get("h");
            Begin = period.GetPointStartTime(TInstant::Seconds(value));
        }

        inline void SetLogFileStockpile(TStringBuf value) {
            LogFileStockpile = TString{value};
        }

    protected:
        void FillFromFileConfig(const NConfig::TConfig& config) override;

    private:
        TFsPath Root;
        TFsPath RulesPath;
        NStockpile::TStockpileSetingsFactory StockpileSettingsFactory;
        TString Tags;
        bool ReadOnly;
        size_t ThreadsCount = 1;
        TMaybe<TString> Period;
        TMaybe<TString> Itype;
        TMaybe<TFsPath> StatePath;
        TInstant End;
        TMaybe<TInstant> Begin;
        TString LogFileStockpile;
    };
}
