#include "uploader_state.h"

#include <infra/yasm/histdb/components/placements/periods.h>

#include <util/system/tempfile.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb;

Y_UNIT_TEST_SUITE(TUploaderStateTest) {
    Y_UNIT_TEST(ReadWrite) {
        const TFsPath path = "test.tmp";
        TTempFile tmp(path.GetName());

        NZoom::NHost::THostName group(TStringBuf("SAS.000"));
        TRecordPeriod period(TRecordPeriod::Get("m5"));
        {
            TProtoUploaderState state(path);
            UNIT_ASSERT_LT(TInstant::Now(), state.GetDumpedTime(group));
        }

        {
            TProtoUploaderState state(path);
            state.ProcessTime(group, TInstant::Days(239));
            state.ProcessTime(group, TInstant::Days(50));
            state.ProcessTime(group, TInstant::Days(17));
        }
        {
            TProtoUploaderState state(path);
            UNIT_ASSERT_VALUES_EQUAL(state.GetDumpedTime(group), TInstant::Days(17));
        }
    }
}
