#pragma once

#include <infra/yasm/histdb/cli-utils/history_uploader/lib/uploader.pb.h>
#include <infra/yasm/common/labels/host/host.h>
#include <infra/yasm/histdb/components/placements/periods.h>

#include <util/generic/maybe.h>

#include <library/cpp/protobuf/protofile/protofile.h>

namespace NHistDb {
    class TProtoUploaderState {
    public:
        TProtoUploaderState(const TFsPath& filePath)
            : ProtoPath(filePath)
            , State(ProtoPath)
        {
        }

        TInstant GetDumpedTime(const NZoom::NHost::THostName& shardName) {
            auto& shardState = GetShardState(shardName);
            return TInstant::Seconds(shardState.GetProcessed());
        }

        void ProcessTime(const NZoom::NHost::THostName& shardName, TInstant time) {
            auto& shardState = GetShardState(shardName);
            assert(time.Seconds() < shardState.GetProcessed());
            shardState.SetProcessed(time.Seconds());
        }

        bool IsFinished() const {
            return State->GetFinished();
        }

        bool IsFinished(const TString& shardName) const {
            auto shardStates = State->GetShardIDToShardStates();

            auto shardData = shardStates.find(shardName);
            if (shardData == shardStates.end()) {
                return false;
            }
            return shardData->second.GetFinished();
        }

        void Finish() {
            State->SetFinished(true);
        }

        void Finish(const TString& shardName) {
            auto shardStates = State->MutableShardIDToShardStates();
            (*shardStates)[shardName].SetFinished(true);
        }

        TString DebugString() {
            return State->ShortDebugString();
        }

    private:
        TUploaderShardState& GetShardState(const NZoom::NHost::THostName& shardName) {
            auto shardStates = State->MutableShardIDToShardStates();
            return (*shardStates)[shardName.GetName()];
        }



    private:
        TFsPath ProtoPath;
        TProtoFileGuard<TUploaderState> State;
    };
}
