#include "settings.h"

#include <infra/yasm/histdb/components/stockpile/stockpile_reader.h>

using namespace NHistDb::NStockpile;
using namespace NHistDb;

int main(int argc, const char** argv) {
    auto requestSettings = GetStockpileRequestSettings(argc, argv);
    auto stockpileSettings = requestSettings.CreateStockpileSettings();
    TLog log;

    NYasm::NCommon::TFastConfigSettings fastConfigSettings = {
        "oauth_token",
        "locke",
        {"//home/yasm/fast_config.json"},
        "fast_config.json",
        NTags::TInstanceKey::FromNamed("yasmdumper")
    };
    TFastConfig fastConfig(log, fastConfigSettings);
    TStockpileState stockpileState(log, stockpileSettings, fastConfig);

    stockpileState.UpdateShards();

    NZoom::NProtobuf::THistoryRequest request{
        .Start = requestSettings.GetStart(),
        .End = requestSettings.GetEnd(),
        .Period = requestSettings.GetPeriod(),
        .HostName = requestSettings.GetHost(),
        .RequestKey = NZoom::NSubscription::TInternedRequestKey(requestSettings.GetRequest()),
        .SignalName = requestSettings.GetSignal()
    };

    TStockpileReader reader(
        stockpileState,
        TDuration::Seconds(5),
        TDuration::Seconds(5),
        TVector<NZoom::NProtobuf::THistoryRequest>{request},
        log
    );

    for (const auto& response : reader.Read()) {
        for (const auto& val: response.Series.GetValues()) {
            Cerr << val << Endl;
        }
        Cerr << Endl;
    }
}
