#include "base.h"

using namespace NHistDb;
using NZoom::NAggregators::TMetagroupAggregator;

TVector<TAbstractFormat::TReadAggregatedData> TAbstractFormat::ReadAggregated(
        size_t offset, size_t limit,
        const TTagSignals &tags,
        const TYasmConf &conf,
        TSnappyInputStream &stream)
const {
    TVector<TReadAggregatedData> result;

    TVector<TTimestamp> times;
    for (const auto i: xrange(offset, offset + limit)) {
        times.push_back(i);
    }

    TVector<std::pair<const TRequestKey&, TMetagroupAggregator>> aggregators;
    aggregators.reserve(tags.size());

    for (const auto& tag : tags) {
        const auto& requestKey = tag.first;
        aggregators.emplace_back(requestKey, TMetagroupAggregator(conf.GetTypeConf(requestKey.GetItype(), false)));
    }

    for (const TReadData& readData: Read(times, tags, stream)) {
        const auto idx = readData.Timestamp - offset;
        auto& requestKeyAndAggregator = aggregators[readData.RequestKeyIndex];
        requestKeyAndAggregator.second.Mul(idx, readData.Record);
    }

    for (auto& requestKeyAndAggregator: aggregators) {
        const auto& requestKey = requestKeyAndAggregator.first;
        auto& aggregator = requestKeyAndAggregator.second;

        for (auto& aggregated: aggregator.GetValues()) {
            auto timestamp = aggregated.Timestamp + offset;
            result.emplace_back(requestKey, timestamp, aggregated.MatchedInstances, std::move(aggregated.Record));
        }
    }

    return result;
}
