#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/labels/tags/request_key.h>
#include <infra/yasm/common/labels/tags/dynamic_filter.h>
#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/aggregators/metagroup.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>
#include <infra/yasm/histdb/components/streams/snappy.h>

namespace NHistDb {
    static constexpr size_t HEADER_VERSION_SIZE = sizeof(ui32);

    class TSignalLimitExceeded : public yexception {
    public:
    };

    class TTimeLimitExceeded : public yexception {
    public:
    };

    using THeaderVersionStorage = std::array<char, HEADER_VERSION_SIZE>;

    class TAbstractFormat : public TNonCopyable {
    private:
        using TSignalName = NZoom::NSignal::TSignalName;
        using TInstanceKey = NTags::TInstanceKey;
        using TRequestKey = NTags::TRequestKey;
        using TRecord = NZoom::NRecord::TRecord;
        using TMatchedInstances = NZoom::NAggregators::TMetagroupAggregator::TMatchedInstances;
        using TYasmConf = NZoom::NYasmConf::TYasmConf;

    public:
        using TTimestamp = ui64;
        using TRequestedIndex = ui64;
        using TRequestKeyIndex = size_t;

        using TTagSignals = TVector<std::pair<TRequestKey, TVector<TSignalName>>>;

        struct TReadData {
            const TRequestKey& RequestKey;
            TRecord Record;
            TTimestamp Timestamp;
            TInstanceKey InstanceKey;
            TRequestKeyIndex RequestKeyIndex;

            TReadData(const TRequestKey& requestKey, TRecord record, TTimestamp timestamp, TInstanceKey instanceKey, TRequestKeyIndex requestKeyIndex)
                : RequestKey(requestKey)
                , Record(std::move(record))
                , Timestamp(timestamp)
                , InstanceKey(instanceKey)
                , RequestKeyIndex(requestKeyIndex)
            {
            }
         };

        struct TReadAggregatedData {
            const TRequestKey& RequestKey;
            TTimestamp Timestamp;
            TMatchedInstances MatchedInstances;
            TRecord Record;

            TReadAggregatedData(const TRequestKey& requestKey, TTimestamp timestamp, TMatchedInstances matchedInstances, TRecord record)
                : RequestKey(requestKey)
                , Timestamp(timestamp)
                , MatchedInstances(matchedInstances)
                , Record(std::move(record))
            {
            }
        };

        virtual ~TAbstractFormat() = default;

        virtual void SaveBlocks(const TVector<TSnappyBlock>& blocks) = 0;
        virtual const TVector<TSnappyBlock>& GetBlocks() const = 0;

        virtual TString Dump() const = 0;

        virtual TMaybe<TTimestamp> FirstRecordTime() const = 0;
        virtual TMaybe<TTimestamp> LastRecordTime() const = 0;

        virtual TVector<TReadData> Read(
                const TVector<TTimestamp>& times,
                const TTagSignals& tags,
                TSnappyInputStream& stream
        ) const = 0;

        TVector<TReadAggregatedData> ReadAggregated(
                TTimestamp offset, size_t limit,
                const TTagSignals& tags,
                const TYasmConf& conf,
                TSnappyInputStream& stream
        ) const;

        virtual THeaderVersionStorage GetVersion() const = 0;
    };
}
