#pragma once

#include "base.h"

#include <infra/yasm/zoom/components/compression/series.h>

namespace NHistDb {
    class TCompactFormat final : public TAbstractFormat {
    private:
        using TTimestamp = TAbstractFormat::TTimestamp;
        using TTagSignals = TAbstractFormat::TTagSignals;
        using TReadData = TAbstractFormat::TReadData;
        using TReadAggregatedData = TAbstractFormat::TReadAggregatedData;
        using TYasmConf = NZoom::NYasmConf::TYasmConf;
        using TInstanceKey = NTags::TInstanceKey;
        using TSignalName = NZoom::NSignal::TSignalName;

    public:
        TCompactFormat();
        TCompactFormat(TMaybe<TStringBuf> incoming);
        TCompactFormat(TStringBuf incoming);
        TCompactFormat(TMaybe<TBlob> incoming);
        TCompactFormat(TBlob incoming);

        virtual ~TCompactFormat();

        void SaveBlocks(const TVector<TSnappyBlock>& blocks) override;
        const TVector<TSnappyBlock>& GetBlocks() const override;

        TString Dump() const override;

        TMaybe<TTimestamp> FirstRecordTime() const override;
        TMaybe<TTimestamp> LastRecordTime() const override;

        void Start(TInstanceKey instanceKey, TSnappyOutputStream& stream);
        void Append(
            TSignalName signalName,
            TTimestamp offset,
            size_t valuesCount,
            NYasmServer::ESeriesKind seriesKind,
            const TString& chunk
        );
        void Commit(TSnappyOutputStream& stream);

        TVector<TReadData> Read(
            const TVector<TTimestamp>& times,
            const TTagSignals& tags,
            TSnappyInputStream& stream
        ) const override;

        THeaderVersionStorage GetVersion() const override;
        static THeaderVersionStorage GetCompactVersion();

    private:
        class TImpl;

        THolder<TImpl> Impl;
    };
}
