#pragma once

#include "something.h"

#include <infra/yasm/zoom/components/serialization/deserializers/msgpack.h>

#include <util/generic/xrange.h>

namespace NHistDb {
    class TSomethingFormat::TKeyIterator {
    public:
        TKeyIterator(const TSomethingFormat& format)
            : Format(format)
            , Iterator(Format.Keys.cbegin())
        {
        }

        bool Next() {
            do {
                if (Iterator == Format.Keys.cend()) {
                    return false;
                }

                CurrentRow.ConstructInPlace(
                    *Iterator,
                    &Format.Signals[std::distance(Format.Keys.cbegin(), Iterator)].second
                );

                ++Iterator;

            } while (CurrentRow->first.Empty());

            return true;
        }

        TKeyIteratorRow& Get() {
            return CurrentRow.GetRef();
        }

    private:
        const TSomethingFormat& Format;

        TVector<TInstanceKey>::const_iterator Iterator;

        TMaybe<TKeyIteratorRow> CurrentRow;
    };
}
