#pragma once

#include "something.h"

namespace NHistDb {
    class TSomethingFormat::TMatcher {
    public:
        TMatcher(
            const TSomethingFormat& header,
            const TVector<TTimestamp>& timestamps,
            const TVector<TInstanceKey>& keys
        )
            : Format(header)
            , Timestamps(timestamps)
            , Keys(keys)
        {
            FillKeyIndices();
        }

        TVector<bool> Match() {
            TVector<bool> matches;
            matches.resize(Timestamps.size(), false);

            size_t position = 0;
            TVector<TDataOffset> intersectedOffsets;
            for (const auto timeIndex : Timestamps) {
                if (timeIndex >= Format.TimeOffsets.size()) {
                    continue;
                }

                for (const auto keyIndex : KeyIndices) {
                    const auto& keyOffsets(Format.KeyOffsets[keyIndex]);
                    const auto& timeOffsets(Format.TimeOffsets[timeIndex]);
                    intersectedOffsets.clear();
                    SetIntersection(keyOffsets.cbegin(), keyOffsets.cend(),
                                    timeOffsets.cbegin(), timeOffsets.cend(),
                                    std::back_inserter(intersectedOffsets));
                    if (!intersectedOffsets.empty()) {
                        matches[position] = true;
                        break;
                    }
                }

                position++;
            }

            return matches;
        }

        void Match(THashSet<TSomethingFormat::TTimestamp>& matches) {
            TVector<TDataOffset> intersectedOffsets;
            for (const auto timeIndex : Timestamps) {
                if (timeIndex >= Format.TimeOffsets.size()) {
                    continue;
                }

                for (const auto keyIndex : KeyIndices) {
                    const auto& keyOffsets(Format.KeyOffsets[keyIndex]);
                    const auto& timeOffsets(Format.TimeOffsets[timeIndex]);
                    intersectedOffsets.clear();
                    SetIntersection(keyOffsets.cbegin(), keyOffsets.cend(),
                                    timeOffsets.cbegin(), timeOffsets.cend(),
                                    std::back_inserter(intersectedOffsets));
                    if (!intersectedOffsets.empty()) {
                        matches.insert(timeIndex);
                        break;
                    }
                }
            }
        }

    private:
        using TKeyIndex = ui64;
        using TDataOffset = ui64;

        void FillKeyIndices() {
            // find appropriate key indices
            for (const auto& key : Keys) {
                const auto it(Format.KeyToIndex.find(key));
                if (it != Format.KeyToIndex.end()) {
                    KeyIndices.emplace_back(it->second);
                }
            }
        }

        const TSomethingFormat& Format;
        const TVector<TTimestamp>& Timestamps;
        const TVector<TInstanceKey>& Keys;

        TVector<TKeyIndex> KeyIndices;
    };
}
