#pragma once

#include "second.h"

#include <util/generic/list.h>

namespace NHistDb {
    class TPlacementContinuousWriter;

    class TContinuousSeriesCursor {
    public:
        TContinuousSeriesCursor(TSomethingBulkWriter& writer, const TSomethingBulkCursor& cursor, const size_t startOffset);

        void Append(NZoom::NValue::TValueRef value);

    private:
        TSomethingBulkWriter& Writer;
        const TSomethingBulkCursor Cursor;
        size_t Offset = 0;
    };

    class TEncodedSeriesCursor {
    public:
        TEncodedSeriesCursor(TCompactWriter writer, NTags::TInstanceKey key, const TRecordPeriod& period);

        void Append(
            NZoom::NSignal::TSignalName signalName,
            TInstant startTime,
            size_t valuesCount,
            NYasmServer::ESeriesKind seriesKind,
            const TString& chunk
        );
        void Commit();

    private:
        TCompactWriter Writer;
        const TRecordPeriod Period;
    };

    class TPlacementContinuousWriter {
    public:
        TPlacementContinuousWriter(const TString& root, const TString& hostName, const TRecordPeriod& period);

        TContinuousSeriesCursor CreateContinuousSeriesCursor(NTags::TInstanceKey key, NZoom::NSignal::TSignalName signal, TInstant startTime);
        TEncodedSeriesCursor CreateEncodedSeriesCursor(NTags::TInstanceKey key, TInstant startTime);

        bool SwitchToCompact(TInstant startTime);

        void Flush(TInstant finishedTime, bool dump=false);
        void Finish();

        TVector<TInstant> ActiveChunks() const;

        TMaybe<TInstant> LastRecordTime();

    private:
        class TChunkState {
        public:
            TChunkState(const TPlacementContinuousWriter& parent, TInstant startTime);

            void Flush(TSomethingFormat::TTimestamp upperBorder);
            void Finish();
            void Dump();

            TInstant GetStartTime() const;
            TSecondPlacementWriter& GetPlacement();
            TSomethingBulkWriter& GetSomethingWriter();
            TCompactWriter& GetCompactWriter();

            bool operator ==(const TChunkState& other) const;

        private:
            const TInstant StartTime;
            TSecondPlacementWriter Placement;

            TMaybe<TSomethingBulkWriter> SomethingWriter;
            TMaybe<TCompactWriter> CompactWriter;
        };

        TChunkState& SelectState(TInstant startTime);

        const TString Root;
        const TString HostName;
        const TRecordPeriod Period;

        // always store no more than two adjacent chunks
        TList<TChunkState> States;
    };
}
