#pragma once

#include <util/datetime/base.h>

namespace NHistDb {
    struct TPeriodDescriptor {
        const TDuration Resolution;
        const size_t RecordsPerFile;
        const TString TargetPrefix;
    };

    class TRecordPeriod {
    public:
        TRecordPeriod(const TPeriodDescriptor& descriptor);
        TRecordPeriod(const TRecordPeriod& other);

        static const TRecordPeriod& Get(const TString& targetPrefix);
        static const TRecordPeriod& Get(const TDuration& resolution);

        static const TVector<TRecordPeriod>& GetAll();

        TDuration GetResolution() const;
        TDuration GetInterval() const;
        TStringBuf GetTargetPrefix() const;
        size_t GetRecordsPerFile() const;

        TInstant GetStartTime(TInstant startTime) const;
        size_t GetOffset(TInstant timestamp) const;
        TInstant FromOffset(TInstant startTime, size_t offset) const;
        TInstant GetPointStartTime(TInstant pointStartTime) const;

    private:
        const TPeriodDescriptor Descriptor;
    };
};
