#include "periods.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NHistDb;

Y_UNIT_TEST_SUITE(TRecordPeriodTest) {
    Y_UNIT_TEST(FiveSeconds) {
        const auto period(TRecordPeriod::Get("s5"));
        UNIT_ASSERT_VALUES_EQUAL(period.GetStartTime(TInstant::Seconds(1530866024)), TInstant::Seconds(1530865500));
        UNIT_ASSERT_VALUES_EQUAL(period.GetOffset(TInstant::Seconds(1530865505)), 1);
        UNIT_ASSERT_VALUES_EQUAL(period.FromOffset(TInstant::Seconds(1530865500), 1), TInstant::Seconds(1530865505));
    }

    Y_UNIT_TEST(FiveMinutes) {
        const auto period(TRecordPeriod::Get("m5"));
        UNIT_ASSERT_VALUES_EQUAL(period.GetStartTime(TInstant::Seconds(1530866024)), TInstant::Seconds(1530810000));
        UNIT_ASSERT_VALUES_EQUAL(period.GetOffset(TInstant::Seconds(1530810300)), 1);
        UNIT_ASSERT_VALUES_EQUAL(period.FromOffset(TInstant::Seconds(1530810000), 1), TInstant::Seconds(1530810300));
    }

    Y_UNIT_TEST(FindByResolution) {
        const auto prefixPeriod(TRecordPeriod::Get("m5"));
        const auto resolutionPeriod(TRecordPeriod::Get(TDuration::Minutes(5)));
        UNIT_ASSERT_VALUES_EQUAL(prefixPeriod.GetResolution(), resolutionPeriod.GetResolution());
        UNIT_ASSERT_VALUES_EQUAL(prefixPeriod.GetTargetPrefix(), resolutionPeriod.GetTargetPrefix());
    }

    Y_UNIT_TEST(WrongPrefix) {
        UNIT_ASSERT_EXCEPTION(TRecordPeriod::Get("wrong"), yexception);
        UNIT_ASSERT_EXCEPTION(TRecordPeriod::Get(TDuration::Seconds(1)), yexception);
    }
}
