#pragma once

#include <infra/yasm/histdb/components/formats/something.h>
#include <infra/yasm/histdb/components/formats/compact.h>
#include <infra/yasm/zoom/components/compression/chunk.h>
#include <infra/yasm/server/lib/zoom_writers.h>

namespace NHistDb {
    class TFormatTranspiler final : public NZoom::NRecord::ISignalValueCallback {
    public:
        void SetTimestamp(TSomethingFormat::TTimestamp timestamp) {
            Timestamp.ConstructInPlace(timestamp);
        }

        void SetObjectsCount(const size_t count) override {
            Chunks.reserve(count);
        }

        void OnSignalValue(const NZoom::NSignal::TSignalName& name, const NZoom::NValue::TValueRef& value) override {
            THolder<NYasmServer::TBaseChunk>& chunk(Chunks[name]);
            if (!chunk) {
                NYasmServer::TValueTyper typer;
                value.Update(typer);
                if (typer.GetType().Defined()) {
                    switch (*typer.GetType()) {
                        case NYasmServer::ESeriesKind::Double: {
                            chunk = MakeHolder<NYasmServer::TDoubleChunk>(*Timestamp);
                            break;
                        }
                        case NYasmServer::ESeriesKind::CountedSum: {
                            chunk = MakeHolder<NYasmServer::TCountedSumChunk>(*Timestamp);
                            break;
                        }
                        case NYasmServer::ESeriesKind::Histogram: {
                            chunk = MakeHolder<NYasmServer::THistogramChunk>(*Timestamp);
                            break;
                        }
                    }
                } else {
                    return;
                }
            }
            chunk->SetTimestamp(*Timestamp);
            value.Update(*chunk);
        }

        void Finish(TCompactFormat& format) {
            for (const auto& signalChunk : Chunks) {
                if (signalChunk.second) {
                    auto& chunk(*signalChunk.second);
                    format.Append(
                        signalChunk.first,
                        chunk.GetStartTime(),
                        chunk.GetValuesWritten(),
                        chunk.GetType(),
                        chunk.GetData()
                    );
                }
            }
            Timestamp.Clear();
            Chunks.clear();
        }

    private:
        TMaybe<TSomethingFormat::TTimestamp> Timestamp;
        THashMap<NZoom::NSignal::TSignalName, THolder<NYasmServer::TBaseChunk>> Chunks;
    };
}
