#include "metrics.h"

#include <infra/yasm/stockpile_client/metrics.h>

using namespace NHistDb::NMetrics;
using NHistDb::NStockpile::NMetrics::TStockpileStatsInitializer;

void THistDbStockpileStatsInitializer::Init(TUnistat& creator) const {
    TStockpileStatsInitializer stockpileInitializer;
    stockpileInitializer.Init(creator);

    DrillHistogramHole(creator, PIPELINE_STOCKPILE_PROCESSING_TIME);
    DrillHistogramHole(creator, PIPELINE_STOCKPILE_PROCESSING_DELAY);
    DrillSummHole(creator, PIPELINE_STOCKPILE_PROCESSED_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_DELAYED_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_FAILED_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_REJECTED_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_EMPTY_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_TYPE_MISMATCH_RECORDS);
    DrillSummHole(creator, PIPELINE_STOCKPILE_SENSOR_TYPE_CHANGE);
    DrillAnnnHole(creator, PIPELINE_STOCKPILE_REMAINING_WORKER_CAPACITY);

    DrillHistogramHole(creator, READER_METABASE_QUERIES);
    DrillHistogramHole(creator, READER_METABASE_SENSORS_PER_REQUEST);
    DrillHistogramHole(creator, READER_METABASE_TOTAL_TIME);
    DrillSummHole(creator, READER_METABASE_TIMEOUTS);
    DrillSummHole(creator, READER_METABASE_ERRORS);

    DrillHistogramHole(creator, READER_STOCKPILE_QUERIES);
    DrillHistogramHole(creator, READER_STOCKPILE_SENSORS_PER_REQUEST);
    DrillHistogramHole(creator, READER_STOCKPILE_TOTAL_TIME);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_DOWNSAMPLED_5M_POINTS);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_1H_POINTS);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_3H_POINTS);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_6H_POINTS);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_12H_POINTS);
    DrillHistogramHole(creator, READER_STOCKPILE_UGRAM_24H_POINTS);
    DrillSummHole(creator, READER_STOCKPILE_TIMEOUTS);
    DrillSummHole(creator, READER_STOCKPILE_ERRORS);
}
