#pragma once

#include <infra/monitoring/common/metrics.h>

#include <util/generic/string.h>

namespace NHistDb::NMetrics {
    static const TString PIPELINE_STOCKPILE_PROCESSING_TIME = "pipeline.stockpile_processing_time";
    static const TString PIPELINE_STOCKPILE_PROCESSING_DELAY = "pipeline.stockpile_processing_delay";
    static const TString PIPELINE_STOCKPILE_PROCESSED_RECORDS = "pipeline.stockpile_processed_records";
    static const TString PIPELINE_STOCKPILE_DELAYED_RECORDS = "pipeline.stockpile_delayed_records";
    static const TString PIPELINE_STOCKPILE_FAILED_RECORDS = "pipeline.stockpile_failed_records";
    static const TString PIPELINE_STOCKPILE_REJECTED_RECORDS = "pipeline.stockpile_rejected_records";
    static const TString PIPELINE_STOCKPILE_EMPTY_RECORDS = "pipeline.stockpile_empty_records";
    static const TString PIPELINE_STOCKPILE_TYPE_MISMATCH_RECORDS = "pipeline.stockpile_type_mismatch_records";
    static const TString PIPELINE_STOCKPILE_SENSOR_TYPE_CHANGE = "pipeline.stockpile_sensor_type_change";
    static const TString PIPELINE_STOCKPILE_REMAINING_WORKER_CAPACITY = "pipeline.worker_capacity";

    static const TString READER_METABASE_QUERIES = "reader.metabase_queries_per_request";
    static const TString READER_METABASE_SENSORS_PER_REQUEST = "reader.metabase_sensors_per_request";
    static const TString READER_METABASE_TOTAL_TIME = "reader.metabase_total_time";
    static const TString READER_METABASE_TIMEOUTS = "reader.metabase_timeouts";
    static const TString READER_METABASE_ERRORS = "reader.metabase_errors";

    static const TString READER_STOCKPILE_QUERIES = "reader.stockpile_queries_per_request";
    static const TString READER_STOCKPILE_SENSORS_PER_REQUEST = "reader.stockpile_sensors_per_request";
    static const TString READER_STOCKPILE_TOTAL_TIME = "reader.stockpile_total_time";
    static const TString READER_STOCKPILE_UGRAM_DOWNSAMPLED_5M_POINTS = "reader.stockpile_ugram_downsampled_5m_points";
    static const TString READER_STOCKPILE_UGRAM_1H_POINTS = "reader.stockpile_ugram_hour_points";
    static const TString READER_STOCKPILE_UGRAM_3H_POINTS = "reader.stockpile_ugram_3_hours_points";
    static const TString READER_STOCKPILE_UGRAM_6H_POINTS = "reader.stockpile_ugram_6_hours_points";
    static const TString READER_STOCKPILE_UGRAM_12H_POINTS = "reader.stockpile_ugram_12_hours_points";
    static const TString READER_STOCKPILE_UGRAM_24H_POINTS = "reader.stockpile_ugram_24_hours_points";
    static const TString READER_STOCKPILE_TIMEOUTS = "reader.stockpile_timeouts";
    static const TString READER_STOCKPILE_ERRORS = "reader.stockpile_errors";

    class THistDbStockpileStatsInitializer final : public NMonitoring::TStatsInitializer {
    public:
        void Init(TUnistat& creator) const;
    };
}
