#pragma once

#include <util/generic/hash_set.h>
#include <infra/yasm/stockpile_client/state.h>

namespace NHistDb {
    class StockpileDataCleaner {
    public:
        StockpileDataCleaner(TLog& logger, NStockpile::TStockpileState& stockpileState);

        void ClearStockpileData(const NZoom::NHost::THostName& hostName,
                                const NStockpile::TMetabaseShardKey& shardKey,
                                TInstant begin,
                                TInstant end);

        inline void ClearStockpileData(const NZoom::NHost::THostName& hostName,
                                       const NStockpile::TMetabaseShardKey& shardKey,
                                       TInstant end) {
            ClearStockpileData(hostName, shardKey, TInstant::Zero(), end);
        }

        void SetLimit(long limit) {
            Limit = limit;
        }

    private:
        NStockpile::TMetabaseShardState ResolveShardForReadUntilReady(const NStockpile::TMetabaseShardKey& shardKey);

        TLog& Logger;
        NStockpile::TGrpcStateHandler Handler;
        NStockpile::TStockpileState& StockpileState;
        size_t Limit;
    };
}
