#pragma once

#include "splitters.h"
#include "signal_key.h"

#include <infra/yasm/histdb/components/placements/continuous.h>
#include <infra/yasm/common/points/accumulators/accumulators.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>

namespace NHistDb {
    class TFiveMinutesVisitor final: public IRecordVisitor {
    public:
        TFiveMinutesVisitor(NZoom::NAccumulators::EAccumulatorType accumulatorType,
                            TContinuousSeriesCursor cursor);

        void OnValue(NZoom::NValue::TValueRef value) override;

        void Flush();

    private:
        NZoom::NAccumulators::TAccumulator Accumulator;
        TContinuousSeriesCursor Cursor;
    };

    class TFiveMinutesPerHostWriter final: public ISnapshotVisitor {
    public:
        TFiveMinutesPerHostWriter(TLog& Logger, const NZoom::NYasmConf::TYasmConf& conf,
                                  const TString& root, NZoom::NHost::THostName hostName, TInstant now);

        void OnRecord(const IRecordDescriptor& recordDescriptor) override;

        TMaybe<TInstant> GetLastTime() override;

        void CollectStats() override;

        void Finish() override;

    private:
        TLog& Logger;

        const NZoom::NYasmConf::TYasmConf& Conf;
        const TRecordPeriod FiveMinutesPeriod;
        const TRecordPeriod FiveSecondsPeriod;
        const NZoom::NHost::THostName HostName;

        TPlacementContinuousWriter Writer;
        const TInstant StartTime;

        NTags::TInstanceKey CurrentInstanceKey;
        TAtomic FlushOffset;
        TAtomic LastTime;

        NImpl::TAccumulatorMapping AccumulatorMapping;
    };

    class TFiveMinutesWriter: public THostSplitter {
    public:
        TFiveMinutesWriter(TLog& Logger, const NZoom::NYasmConf::TYasmConf& conf,
                           const TString& root, TInstant now);

        THolder<ISnapshotVisitor> CreateVisitor(NZoom::NHost::THostName hostName) override;

    protected:
        TLog& Logger;
        const NZoom::NYasmConf::TYasmConf& Conf;
        const TString Root;
        const TInstant Now;
    };

    class THostFiveMinutesWriter final: public TFiveMinutesWriter {
    public:
        using TFiveMinutesWriter::TFiveMinutesWriter;

        static TVector<NZoom::NHost::THostName> GetHostNames(const TString& root);
    };

    class TGroupFiveMinutesWriter final: public TFiveMinutesWriter {
    public:
        using TFiveMinutesWriter::TFiveMinutesWriter;

        static TVector<NZoom::NHost::THostName> GetHostNames(const TString& root);
    };
}
