#pragma once

#include "splitters.h"

#include <infra/yasm/histdb/components/placements/continuous.h>

namespace NHistDb {

    class TFiveSecondsWriter: public THostSplitter {
    public:
        TFiveSecondsWriter(TLog& logger, const TString& root, TInstant now);

        THolder<ISnapshotVisitor> CreateVisitor(NZoom::NHost::THostName hostName) override;

    protected:
        TLog& Logger;
        const TString Root;
        const TInstant Now;
    };

    class THostFiveSecondsWriter final: public TFiveSecondsWriter {
    public:
        using TFiveSecondsWriter::TFiveSecondsWriter;

        static TVector<NZoom::NHost::THostName> GetHostNames(const TString& root);
    };

    class TGroupFiveSecondsWriter final: public TFiveSecondsWriter {
    public:
        using TFiveSecondsWriter::TFiveSecondsWriter;

        static TVector<NZoom::NHost::THostName> GetHostNames(const TString& root);
    };
}
