#include "handlers.h"

#include <infra/monitoring/common/perf.h>
#include <infra/monitoring/common/msgpack.h>

using namespace NHistDb;
using namespace NMonitoring;

void TPingHandler::DoReply(const NMonitoring::TServiceRequest::TRef request, const TParsedHttpFull&) {
    TMeasuredMethod perf(Logger, "", NMetrics::HANDLERS_PING_TIME);
    request->Finish(THttpResponse(HttpCodes::HTTP_OK).SetContent("OK"));
}

void TLastTimeHandler::DoReply(const NMonitoring::TServiceRequest::TRef request, const TParsedHttpFull&) {
    TMeasuredMethod perf(Logger, "", NMetrics::HANDLERS_LAST_TIME);

    const auto lastTime(Pipeline.GetLastTime());

    msgpack::sbuffer buffer;
    msgpack::packer<msgpack::sbuffer> packer(&buffer);
    packer.pack_map(1);
    PackString(packer, "last_time");
    if (lastTime.Defined()) {
        packer.pack_uint64(lastTime->Seconds());
    } else {
        packer.pack_nil();
    }

    request->Finish(THttpResponse(HttpCodes::HTTP_OK).SetContent(TString(buffer.data(), buffer.size())));
}
