#pragma once

#include "metrics.h"
#include "stockpile_pipeline.h"

#include <infra/yasm/histdb/components/streams/snappy.h>
#include <infra/yasm/histdb/components/formats/something.h>

#include <infra/monitoring/common/application.h>

namespace NHistDb {
    class TPingHandler: public NMonitoring::IServiceReplier {
    public:
        TPingHandler(TLog& logger)
            : Logger(logger)
        {
        }

        void DoReply(const NMonitoring::TServiceRequest::TRef request, const TParsedHttpFull& meta) override;

    private:
        TLog& Logger;
    };

    class TLastTimeHandler: public NMonitoring::IServiceReplier {
    public:
        TLastTimeHandler(TLog& logger, TWritingStockpilePipeline& pipeline)
            : Logger(logger)
            , Pipeline(pipeline)
        {
        }

        void DoReply(const NMonitoring::TServiceRequest::TRef request, const TParsedHttpFull& meta) override;

    private:
        TLog& Logger;
        TWritingStockpilePipeline& Pipeline;
    };

    class TDumperHandlersCollection {
    public:
        TDumperHandlersCollection(TLog& logger, TWritingStockpilePipeline& pipeline) {
            // Debug or readiness handle.
            Handlers.emplace_back("/ping", MakeHolder<TPingHandler>(logger));

            // Alias for /ping. Used in nanny-services readyness checks.
            Handlers.emplace_back("/ready/", MakeHolder<TPingHandler>(logger));

            // Debug handle. Returns timestamp of a last fully dumped tsdb snapshot.
            Handlers.emplace_back("/stockpile-last-time", MakeHolder<TLastTimeHandler>(logger, pipeline)); // debug handle
        }

        void Register(NMonitoring::TWebServer& server) {
            for (const auto& pair : Handlers) {
                server.Add(pair.first, *pair.second);
            }
        }

    private:
        TVector<std::pair<TString, THolder<NMonitoring::IServiceReplier>>> Handlers;
    };
}
