#include "metrics.h"

#include <infra/yasm/histdb/components/stockpile/metrics.h>

using namespace NHistDb::NMetrics;

void TDumperStatsInitializer::Init(TUnistat& creator) const {
    THistDbStockpileStatsInitializer stockpileInitializer;
    stockpileInitializer.Init(creator);

    DrillHistogramHole(creator, NMetrics::HANDLERS_PING_TIME);

    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_MINUTES_PROCESSING_TIME);
    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_MINUTES_FLUSH_TIME);
    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_MINUTES_PROCESSING_DELAY);
    DrillSummHole(creator, NMetrics::PIPELINE_FIVE_MINUTES_PROCESSED_RECORDS);

    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_SECONDS_PROCESSING_TIME);
    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_SECONDS_FLUSH_TIME);
    DrillHistogramHole(creator, NMetrics::PIPELINE_FIVE_SECONDS_PROCESSING_DELAY);
    DrillSummHole(creator, NMetrics::PIPELINE_FIVE_SECONDS_PROCESSED_RECORDS);

    DrillSummHole(creator, NMetrics::PIPELINE_SKIPPED_BAD_SNAPSHOTS);
    DrillSummHole(creator, NMetrics::PIPELINE_SNAPSHOT_RETRIES);

    DrillSummHole(creator, NMetrics::PIPELINE_OVERLOADED);
}
