#pragma once

#include <infra/monitoring/common/metrics.h>

#include <util/generic/string.h>

namespace NHistDb::NMetrics {
    static const TString HANDLERS_PING_TIME = "handlers.ping_time";
    static const TString HANDLERS_LAST_TIME = "handlers.last_time";

    static const TString PIPELINE_FIVE_MINUTES_PROCESSING_TIME = "pipeline.five_minutes_processing_time";
    static const TString PIPELINE_FIVE_MINUTES_FLUSH_TIME = "pipeline.five_minutes_flush_time";
    static const TString PIPELINE_FIVE_MINUTES_PROCESSING_DELAY = "pipeline.five_minutes_processing_delay";
    static const TString PIPELINE_FIVE_MINUTES_PROCESSED_RECORDS = "pipeline.five_minutes_processed_records";

    static const TString PIPELINE_FIVE_SECONDS_PROCESSING_TIME = "pipeline.five_seconds_processing_time";
    static const TString PIPELINE_FIVE_SECONDS_FLUSH_TIME = "pipeline.five_seconds_flush_time";
    static const TString PIPELINE_FIVE_SECONDS_PROCESSING_DELAY = "pipeline.five_seconds_processing_delay";
    static const TString PIPELINE_FIVE_SECONDS_PROCESSED_RECORDS = "pipeline.five_seconds_processed_records";

    static const TString PIPELINE_SKIPPED_BAD_SNAPSHOTS = "pipeline.skipped_bad_snapshots";
    static const TString PIPELINE_SNAPSHOT_RETRIES = "pipeline.snapshot_retries";

    static const TString PIPELINE_OVERLOADED = "pipeline.overloaded";

    class TDumperStatsInitializer final: public NMonitoring::TStatsInitializer {
    public:
        void Init(TUnistat& creator) const;
    };
}
