#pragma once

#include "splitters.h"
#include "five_seconds_writer.h"
#include "five_minutes_writer.h"

namespace NHistDb {
    class TWritingPipeline final: public ISnapshotVisitor {
    public:
        TWritingPipeline(TLog& logger, const NZoom::NYasmConf::TYasmConf& conf, const TString& root,
                         size_t threadCount, TInstant now);

        void OnRecord(const IRecordDescriptor& recordDescriptor) override;

        TMaybe<TInstant> GetLastTime() override;
        void AddLastTimesToFinder(ITimeFinder& finder) override;

        // Get the min last time of host or group chunks, but ignore times that are older than the specified timestamp.
        // If all of the chunks were ignored then return timestamp specified in argument.
        TMaybe<TInstant> GetHostOrGroupLastTime(TInstant limit, bool hostChunks);

        void Preload();

        void Start();
        void Stop();
        void Finish() override;

    private:
        void CreateHostThread();
        void CreateGroupThread();

    private:
        TLog Logger;
        const NZoom::NYasmConf::TYasmConf& Conf;
        const TString Root;
        const TInstant Now;

        TList<THostFiveSecondsWriter> HostFiveSecondsWriters;
        TList<THostFiveMinutesWriter> HostFiveMinutesWriters;
        TList<TUnitingVisitor> HostUnitingWriters;
        THostQueueSplitter HostSplitter;

        TList<TGroupFiveSecondsWriter> GroupFiveSecondsWriters;
        TList<TGroupFiveMinutesWriter> GroupFiveMinutesWriters;
        TList<TUnitingVisitor> GroupUnitingWriters;
        THostQueueSplitter GroupSplitter;
    };
}
