#include "pipeline.h"

#include <infra/yasm/histdb/components/dumper/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/folder/tempdir.h>

using namespace NHistDb;
using namespace NZoom::NValue;
using namespace NZoom::NYasmConf;

Y_UNIT_TEST_SUITE(TWritingPipelineTest) {

    Y_UNIT_TEST(Visiting) {
        TLog logger;
        const auto yasmConf(TYasmConf::FromString(
            TStringBuf("{\"conflist\": {\"common\": {\"signals\": {}, \"patterns\": {}, \"periods\": {}}}}")));

        TRecordPeriod period(TRecordPeriod::Get("s5"));
        TInstant startTime(period.GetStartTime(TInstant::Now()));

        TMockedSnapshotDescriptor snapshot;
        TVector<TValue> values{42};
        auto& record(snapshot
            .GetRecordDescriptor()
            .SetValues(values)
            .SetStartTime(startTime)
            .SetEndTime(startTime)
            .SetFlushOffset(startTime));

        TTempDir root;
        TWritingPipeline pipeline(logger, yasmConf, root.Name(), 1, startTime);
        pipeline.Start();

        pipeline.OnRecord(record);

        pipeline.Stop();
    }
}
