#include "signal_key.h"

#include <util/digest/numeric.h>

using namespace NHistDb::NImpl;
using namespace NTags;
using namespace NZoom::NSignal;
using namespace NZoom::NAccumulators;
using namespace NZoom::NYasmConf;
using namespace NZoom::NContainers;

TSignalKey::TSignalKey(TInstanceKey instanceKey, TSignalName signalName)
    : InstanceKey(instanceKey)
    , SignalName(signalName)
{
}

size_t TSignalKey::Hash() const noexcept {
    return CombineHashes(InstanceKey.Hash(), SignalName.Hash());
}

bool TSignalKey::operator==(const TSignalKey& other) const {
    return InstanceKey == other.InstanceKey && SignalName == other.SignalName;
}

NTags::TInstanceKey TSignalKey::GetInstanceKey() const {
    return InstanceKey;
}

NZoom::NSignal::TSignalName TSignalKey::GetSignalName() const {
    return SignalName;
}

TAccumulatorDescriptor::TAccumulatorDescriptor(EAccumulatorType type)
    : Type(type)
{
}

TAccumulatorMapping::TAccumulatorMapping(const NZoom::NYasmConf::TYasmConf& conf)
    : Conf(conf)
{
}

TMaybe<EAccumulatorType> TAccumulatorMapping::GetAccumulatorType(TAccumulatorDescriptor* descriptor) {
    if (descriptor != nullptr) {
        return {descriptor->Type};
    } else {
        return Nothing();
    }
}

TMaybe<EAccumulatorType> TAccumulatorMapping::GetAccumulatorType(const TSignalKey& signalKey) {
    const auto itype(signalKey.GetInstanceKey().GetItype());

    TAccumulatorMap::insert_ctx ctx;
    auto newIt(Accumulators.find(itype, ctx));
    if (newIt != Accumulators.end()) {
        return GetAccumulatorType(newIt->second.GetAccumulator(signalKey.GetSignalName()));
    }

    const auto& conf(Conf.GetTypeConf(itype, true));
    auto it = Accumulators.emplace_direct(ctx, itype, TStorage<TAccumulatorDescriptor>(conf.GetSignals(), conf.GetPatterns(), EAggregationMethod::Rollup));
    return GetAccumulatorType(it->second.GetAccumulator(signalKey.GetSignalName()));
}
