#pragma once

#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>
#include <infra/yasm/zoom/components/containers/storage.h>
#include <infra/yasm/common/labels/tags/instance_key.h>

namespace NHistDb {
    namespace NImpl {
        class TSignalKey {
        public:
            TSignalKey(NTags::TInstanceKey instanceKey, NZoom::NSignal::TSignalName signalName);

            size_t Hash() const noexcept;
            bool operator==(const TSignalKey& other) const;

            NTags::TInstanceKey GetInstanceKey() const;
            NZoom::NSignal::TSignalName GetSignalName() const;

        private:
            NTags::TInstanceKey InstanceKey;
            NZoom::NSignal::TSignalName SignalName;
        };

        struct TAccumulatorDescriptor {
            TAccumulatorDescriptor(NZoom::NAccumulators::EAccumulatorType type);

            const NZoom::NAccumulators::EAccumulatorType Type;
        };

        class TAccumulatorMapping {
        public:
            TAccumulatorMapping(const NZoom::NYasmConf::TYasmConf& conf);

            TMaybe<NZoom::NAccumulators::EAccumulatorType> GetAccumulatorType(TAccumulatorDescriptor* descriptor);
            TMaybe<NZoom::NAccumulators::EAccumulatorType> GetAccumulatorType(const TSignalKey& signalKey);

        private:
            using TAccumulatorMap = THashMap<TString, NZoom::NContainers::TStorage<TAccumulatorDescriptor>>;

            const NZoom::NYasmConf::TYasmConf& Conf;
            TAccumulatorMap Accumulators;
        };
    }
}

template <>
struct THash<NHistDb::NImpl::TSignalKey> {
    inline size_t operator()(const NHistDb::NImpl::TSignalKey& v) const noexcept {
        return v.Hash();
    }
};
