#pragma once

#include <infra/yasm/histdb/components/dumper/ifaces.h>
#include <infra/yasm/server/persistence/reader.h>

#include <library/cpp/deprecated/atomic/atomic.h>

#include <util/system/thread.h>
#include <util/system/event.h>
#include <util/system/mutex.h>

namespace NHistDb {
    class TSnapshotReader {
    public:
        using TParsedSnapshotName = NYasmServer::NPersistence::TParsedSnapshotName;

        TSnapshotReader(TLog& logger, const TFsPath& root, TInstant startingOffset, ISnapshotVisitor& visitor);
        virtual ~TSnapshotReader();

        static void* DoRun(void* self) noexcept;

        void Start();
        void Stop();

    protected:
        static constexpr size_t MAX_RETRIES = 2;

        virtual TMaybe<TParsedSnapshotName> ReadNext(TMaybe<TParsedSnapshotName> lastProcessed) = 0;

        TLog& Logger;
        const TFsPath Root;
        const TInstant StartingOffset;
        ISnapshotVisitor& Visitor;
        TMaybe<TParsedSnapshotName> LastProcessed;
        size_t Attempt = 0;

    private:
        bool OnTick();

        TAutoEvent Event;
        TAtomic Done;
        TMutex ThreadMutex;
        THolder<TThread> Thread;
    };

    class THostSnapshotReader final: public TSnapshotReader {
    public:
        using TSnapshotReader::TSnapshotReader;

    protected:
        TMaybe<TParsedSnapshotName> ReadNext(TMaybe<TParsedSnapshotName> lastProcessed);
    };

    class TGroupSnapshotReader final: public TSnapshotReader {
    public:
        using TSnapshotReader::TSnapshotReader;

    protected:
        TMaybe<TParsedSnapshotName> ReadNext(TMaybe<TParsedSnapshotName> lastProcessed);
    };

    class TStockpileSnapshotReader final: public TSnapshotReader {
    public:
        using TSnapshotReader::TSnapshotReader;

    protected:
        TMaybe<TParsedSnapshotName> ReadNext(TMaybe<TParsedSnapshotName> lastProcessed);
    };
}
