#pragma once

#include "splitters.h"

#include <infra/yasm/histdb/components/stockpile/stockpile_writer.h>
#include <infra/yasm/common/config/fast_config.h>

#include <util/generic/list.h>

namespace NHistDb {
    class TWritingStockpilePipeline final: public ISnapshotVisitor {
    public:
        TWritingStockpilePipeline(
            TLog& logger,
            size_t stockpileThreadCount,
            const NStockpile::TSettings& settings,
            const NYasm::NCommon::TFastConfigSettings& fastConfigSettings,
            const TStockpileWriterSettings& writerSettings
        );

        void OnRecord(const IRecordDescriptor& recordDescriptor) override;

        TMaybe<TInstant> GetLastTime() override;

        void StartFastConfig();
        void StopFastConfig();

        void Start();
        void Interrupt();
        void Finish() override;

    private:
        void CreateStockpileThread(size_t index);

    private:
        TLog Logger;

        NYasm::NCommon::TFastConfig FastConfig;
        const TStockpileWriterSettings WriterSettings;

        NStockpile::TStockpileState StockpileState;
        TList<TStockpileWriter> StockpileWriters;
        TInstanceKeyQueueSplitter StockpileSplitter;

        TStockpileDumperStats WriterStats;
    };
}
