#include "stockpile_state.h"

using namespace NHistDb;


TStockpileDumperState::TStockpileDumperState(const TFsPath& path, TWritingStockpilePipeline& writingPipeline)
        : Path(path)
        , WritingStockpilePipeline{writingPipeline}
{
}

TInstant TStockpileDumperState::GetLastTimeDumped() const {
    return TInstant::Seconds(GetProtoFile()->GetLastTimeDumped());
}

void TStockpileDumperState::SetLastTimeDumper(const TInstant& lastTime) {
    GetProtoFile()->SetLastTimeDumped(lastTime.Seconds());
}

void TStockpileDumperState::Start() {
    UpdateDumpStateJob = NMonitoring::StartPeriodicJob([this] { UpdateState(); }, TDuration::Seconds(30));
}

TProtoFileGuard<TStockpileState> TStockpileDumperState::GetProtoFile() const {
    return {Path};
}

void TStockpileDumperState::UpdateState() {
    auto startTime = WritingStockpilePipeline.GetLastTime();
    if (startTime.Defined() && startTime->Seconds() != GetLastTimeDumped().Seconds()) {
        SetLastTimeDumper(startTime.GetRef());
    }
}
