#pragma once

#include "stockpile_pipeline.h"

#include <infra/yasm/histdb/dumper/lib/state.pb.h>
#include <infra/monitoring/common/periodic_task.h>

#include <util/folder/path.h>
#include <library/cpp/protobuf/protofile/protofile.h>

namespace NHistDb {
    class TStockpileDumperState {
    public:
        TStockpileDumperState(const TFsPath& path, TWritingStockpilePipeline& writingPipeline);
        TInstant GetLastTimeDumped() const;
        void SetLastTimeDumper(const TInstant& lastTime);
        void Start();

    private:
        TProtoFileGuard<TStockpileState> GetProtoFile() const;
        void UpdateState();

        TFsPath Path;
        TWritingStockpilePipeline& WritingStockpilePipeline;
        NMonitoring::TPeriodicTaskPtr UpdateDumpStateJob;
    };
}


