#include "something.h"

using namespace NHistDb;

TSimpleSomethingFormat::TSimpleSomethingFormat(const TString& fileName, ESnappyMode mode, bool useDirect)
    : Format_(MakeAtomicShared<TSomethingFormat>())
    , File_(fileName, mode, Format_->GetBlocks(), useDirect)
{
}

TSimpleSomethingFormat::TSimpleSomethingFormat(
        TStringBuf incoming, const TString& fileName, ESnappyMode mode, bool, bool useDirect
)
    : Format_(MakeAtomicShared<TSomethingFormat>(incoming))
    , File_(fileName, mode, Format_->GetBlocks(), useDirect)
{
}

TString TSimpleSomethingFormat::Dump() {
    File_.Flush();
    Format_->SaveBlocks(File_.Blocks());
    return Format_->Dump();
}

void TSimpleSomethingFormat::WriteRecord(
    ui64 timestamp,
    const TString& key,
    const NZoom::NRecord::TRecord& record
) {
    Format_->WriteRecord(timestamp, NTags::TInstanceKey::FromNamed(key), record, File_.GetOutputStream());
}

TVector<bool> TSimpleSomethingFormat::HasRecords(
    const TVector<ui64>& timestamps,
    const TVector<TString>& rawKeys
) {
    TVector<NTags::TInstanceKey> keys;
    keys.reserve(rawKeys.size());
    for (const auto& rawKey : rawKeys) {
        keys.emplace_back(NTags::TInstanceKey::FromNamed(rawKey));
    }
    return Format_->HasRecords(timestamps, keys);
}

TVector<TSimpleSomethingRow> TSimpleSomethingFormat::ReadRecords(
    const TVector<ui64>& timestamps,
    const TVector<std::pair<TString, TVector<TString>>>& rawKeysAndSignals
) {
    TVector<std::pair<NTags::TInstanceKey, TVector<NZoom::NSignal::TSignalName>>> keysAndSignals;
    keysAndSignals.reserve(rawKeysAndSignals.size());
    for (const auto& pair : rawKeysAndSignals) {
        TVector<NZoom::NSignal::TSignalName> signals;
        signals.reserve(pair.second.size());
        signals.insert(signals.end(), pair.second.begin(), pair.second.end());
        keysAndSignals.emplace_back(NTags::TInstanceKey::FromNamed(pair.first), std::move(signals));
    }

    TVector<TSimpleSomethingRow> result;
    for (auto& row : Format_->ReadRecords(timestamps, keysAndSignals, File_.GetInputStream())) {
        result.emplace_back(std::move(row));
    }
    return result;
}

TSimpleSomethingIterator TSimpleSomethingFormat::IterateRecords(const TVector<ui64>& timestamps) {
    return {Format_->IterateRecords(timestamps, File_.GetInputStream())};
}

TSimpleSomethingKeyIterator TSimpleSomethingFormat::IterateKeys() {
    return {Format_->IterateKeys()};
}

TMaybe<ui64> TSimpleSomethingFormat::FirstRecordTime() {
    return Format_->FirstRecordTime();
}

TMaybe<ui64> TSimpleSomethingFormat::LastRecordTime() {
    return Format_->LastRecordTime();
}

TVector<TReadData> TSimpleSomethingFormat::Read(
    TVector<ui64>& times,
    TVector<std::pair<TString, TVector<TString>>>& rawTags
) {
    TVector<std::pair<NTags::TRequestKey, TVector<NZoom::NSignal::TSignalName>>> tags;
    for (auto& tag: rawTags) {
        Sort(tag.second);
        TVector<NZoom::NSignal::TSignalName> signals(tag.second.begin(), tag.second.end());
        auto requestKey = NTags::TRequestKey::FromString(tag.first);
        tags.emplace_back(std::move(requestKey), std::move(signals));
    }

    TVector<TReadData> result;
    auto read = Format_->Read(times, tags, File_.GetInputStream());
    result.reserve(read.size());
    for (auto& res: read){
        result.emplace_back(res.Timestamp, res.Record, res.RequestKey, res.InstanceKey);
    }
    return result;
}

void TSimpleSomethingFormat::Finish() {
    File_.Finish();
}
