#pragma once

#include <infra/yasm/histdb/server/lib/metrics.h>
#include <infra/yasm/histdb/server/lib/settings.h>

#include <infra/monitoring/common/proto_replier.h>
#include <infra/yasm/common/threaded_executor.h>
#include <infra/yasm/common/config/fast_config.h>
#include <infra/yasm/interfaces/internal/history_api.pb.h>
#include <infra/yasm/histdb/components/stockpile/stockpile_reader.h>
#include <infra/yasm/histdb/components/placements/second.h>
#include <infra/yasm/zoom/components/serialization/history/history.h>

namespace NHistDb {
    using TProtoHistoryRequest = NYasm::NInterfaces::NInternal::THistoryReadAggregatedRequest;
    using TProtoHistoryResponse = NYasm::NInterfaces::NInternal::THistoryReadAggregatedResponse;

    class IHistoryRequester {
    public:
        virtual TVector<NZoom::NProtobuf::THistoryResponse> ReadHistoryData(
            const TVector<NZoom::NProtobuf::THistoryRequest>& requests, TInstant deadline, const TString& requestId) = 0;
    };

    class THistDbRequester: public IHistoryRequester {
    public:
        THistDbRequester(const TString& root,
                         TSecondHeaderCache& headerCache,
                         const NZoom::NYasmConf::TYasmConf& yasmConf,
                         TLog& logger,
                         const TReplicaIndex replicaIndex = TReplicaIndex())
            : Root(root)
            , HeaderCache(headerCache)
            , YasmConf(yasmConf)
            , Logger(logger)
            , ReplicaIndex(replicaIndex) {
        }

        TVector<NZoom::NProtobuf::THistoryResponse> ReadHistoryData(const TVector<NZoom::NProtobuf::THistoryRequest>& requests,
                                                                    TInstant deadline, const TString& requestId) final;
        TReplicaIndex GetReplicaIndex() const;

    private:
        TString Root;
        TSecondHeaderCache& HeaderCache;
        const NZoom::NYasmConf::TYasmConf& YasmConf;
        TLog& Logger;
        TReplicaIndex ReplicaIndex;
    };

    class TStockpileRequester: public IHistoryRequester {
    public:
        TStockpileRequester(NStockpile::TStockpileState& stockpileState,
                            TDuration metabaseTimeout,
                            TDuration stockpileTimeout,
                            TLog& logger,
                            const TReplicaIndex replicaIndex = TReplicaIndex())
            : StockpileState(stockpileState)
            , MetabaseTimeout(metabaseTimeout)
            , StockpileTimeout(stockpileTimeout)
            , Logger(logger)
            , ReplicaIndex(replicaIndex) {
        }

        TVector<NZoom::NProtobuf::THistoryResponse> ReadHistoryData(const TVector<NZoom::NProtobuf::THistoryRequest>& requests,
                                                                    TInstant deadline, const TString& requestId) final;
        TReplicaIndex GetReplicaIndex() const;

    private:
        NStockpile::TStockpileState& StockpileState;
        const TDuration MetabaseTimeout;
        const TDuration StockpileTimeout;
        TLog& Logger;
        TReplicaIndex ReplicaIndex;
    };
}
