#include "metrics.h"

#include <infra/yasm/histdb/components/stockpile/metrics.h>

using namespace NHistDb::NMetrics;

void THistDbServerStatsInitializer::Init(TUnistat& creator) const {
    THistDbStockpileStatsInitializer stockpileInitializer;
    stockpileInitializer.Init(creator);

    DrillHistogramHole(creator, HANDLERS_PING_TIME);
    DrillHistogramHole(creator, HANDLERS_AGGREGATED_READ_TIME);
    DrillHistogramHole(creator, HANDLERS_STOCKPILE_READ_TIME);
    DrillHistogramHole(creator, HANDLERS_HEADER_LOADING_TIME);

    DrillHistogramHole(creator, HANDLERS_READ_STOCKPILE_HISTORY_TIME);

    DrillHistogramHole(creator, REQUESTER_READ_HISTDB_TIME);
    DrillHistogramHole(creator, REQUESTER_READ_STOCKPILE_TIME);

    DrillHistogramHole(creator, REQUESTER_READ_HISTDB_TOTAL_POINTS);

    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_OK);
    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_NOT_FOUND);
    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_LIMIT_EXCEEDED);
    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_TIME_EXCEEDED);
    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_INTERNAL_ERROR);
    DrillSummHole(creator, REQUESTER_STOCKPILE_STATUS_CODE_PARTIAL);
}
