#pragma once

#include <infra/monitoring/common/application.h>

#include <util/generic/string.h>

namespace NHistDb::NMetrics {
    static const TString HANDLERS_PING_TIME = "handlers.ping_time";
    static const TString HANDLERS_AGGREGATED_READ_TIME = "handlers.aggregated_read_time";
    static const TString HANDLERS_HEADER_LOADING_TIME = "handlers.header_loading_time";
    static const TString HANDLERS_STOCKPILE_READ_TIME = "handlers.stockpile_read_time";

    static const TString HANDLERS_READ_STOCKPILE_HISTORY_TIME = "handlers.read_stockpile_history_time";

    static const TString REQUESTER_READ_HISTDB_TIME = "requester.read_histdb_time";
    static const TString REQUESTER_READ_STOCKPILE_TIME = "requester.read_stockpile_time";

    static const TString REQUESTER_READ_HISTDB_TOTAL_POINTS = "requester.read_histdb_points";

    static const TString REQUESTER_STOCKPILE_STATUS_CODE_OK = "requester.response_code_ok";
    static const TString REQUESTER_STOCKPILE_STATUS_CODE_NOT_FOUND = "requester.response_code_not_found";
    static const TString REQUESTER_STOCKPILE_STATUS_CODE_LIMIT_EXCEEDED = "requester.response_code_limit_exceeded";

    static const TString REQUESTER_STOCKPILE_STATUS_CODE_TIME_EXCEEDED = "requester.response_code_time_exceeded";
    static const TString REQUESTER_STOCKPILE_STATUS_CODE_INTERNAL_ERROR = "requester.response_code_internal_error";
    static const TString REQUESTER_STOCKPILE_STATUS_CODE_PARTIAL = "requester.response_code_partial";

    class THistDbServerStatsInitializer final: public NMonitoring::TStatsInitializer {
    public:
        void Init(TUnistat& creator) const override;
    };
}
