#include "proto_handlers.h"

using namespace NHistDb;
using namespace NZoom::NProtobuf;

namespace {
    static constexpr TDuration READ_TIMEOUT = TDuration::Seconds(30);
}

void TReadHistoryHandler::Handle(TProtoContext& context) {
    NMonitoring::TRequestLog logger(Logger, context.Request.GetRequestId());
    context.ReplyingContext.RequestId = context.Request.GetRequestId();

    logger << TLOG_INFO << "start request";

    TInstant deadline(READ_TIMEOUT.ToDeadLine());
    if (context.Request.GetDeadlineTimestamp()) {
        deadline = Min(deadline, TInstant::Seconds(context.Request.GetDeadlineTimestamp()));
    }
    if (TInstant::Now() > deadline) {
        ythrow NMonitoring::TTooManyRequestsError() << "deadline exceeded";
    }

    auto historyResponses = Requester.ReadHistoryData(THistoryRequest::FromProto(context.Request), deadline,
        context.Request.GetRequestId());

    THistoryResponseWriter responseWriter(context.Response);
    responseWriter.Reserve(historyResponses.size());
    for (const auto& historyResponse : historyResponses) {
        responseWriter.Add(historyResponse);
    }
}
