#pragma once

#include <infra/monitoring/common/proto_replier.h>
#include <infra/yasm/histdb/server/lib/data_requesters.h>

namespace NHistDb {
    class TReadHistoryHandler final: public NMonitoring::TAbstractProtoReplier<TProtoHistoryRequest, TProtoHistoryResponse> {
    public:
        TReadHistoryHandler(IHistoryRequester& requester, const TString& timingMetricName, TLog& logger)
            : Requester(requester)
            , Logger(logger)
            , TimingMetricName(timingMetricName){
        }

        const TString& GetTimingMetricName() const override {
            return TimingMetricName;
        }

        const TString& GetHandleName() const override {
            return TimingMetricName;
        }

        TLog& GetLogger() override {
            return Logger;
        }

        void Handle(TProtoContext& context) override;

    private:
        IHistoryRequester& Requester;
        TLog& Logger;
        TString TimingMetricName;
    };
}
