#include <infra/monitoring/common/application.h>
#include <infra/yasm/histdb/server/lib/handlers.h>
#include <infra/yasm/histdb/server/lib/metrics.h>
#include <infra/yasm/histdb/server/lib/settings.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>

using namespace NHistDb;
using namespace NMonitoring;
using namespace NZoom::NYasmConf;

class THistDbServer final : public TBaseApplication<TServerSettings> {
public:
    THistDbServer(TLog& logger, const TServerSettings& settings)
        : TBaseApplication(logger, settings)
        , HttpHandlers(logger, settings)
    {
        NStockpile::TGrpcSettings::Init("yasmhserver", logger);
    }

    void Run() override {
        HttpHandlers.Start();
        HttpHandlers.Register(HttpServer);
        HttpServer.StartServing();
        Event.Wait();
    }

    void Stop(int signal) override {
        TBaseApplication::Stop(signal);
        HttpHandlers.Stop();
    }

    static void FillParser(NLastGetopt::TOpts& opts) {
        TServerSettings::FillParser(opts);
    }

    static void ProcessParsedOptions(const NLastGetopt::TOptsParseResult& parsed, TServerSettings& settings) {
        settings.ProcessParsedOptions(parsed);
        settings.SetEnableCompression(true);
        settings.SetClientTimeout(TDuration::Seconds(10));
    }

    THolder<TStatsInitializer> GetStatsInitializer() override {
        return MakeHolder<NHistDb::NMetrics::THistDbServerStatsInitializer>();
    }

private:
    THistDbHandlersCollection HttpHandlers;
};

int main(int argc, const char** argv) {
    return RunFromMain<THistDbServer, TServerSettings, TThreadedLoggerFactory>(argc, argv);
}
