import errno
import pyneh
import json


def print_resp(resp):
    if not resp.ready:
        print("{} not ready".format(resp))
    elif resp.failed and resp.status_code:
        print("{} failed: error_text={!r} status_code={!r} duration={!r}".format(resp, resp.error_text, resp.status_code, resp.duration))
    elif resp.failed:
        print("{} failed: error_text={!r} error_code={!r} duration={!r}".format(resp, resp.error_text, errno.errorcode[resp.error_code], resp.duration))
    else:
        print("{} working: data={!r} duration={!r}".format(resp, json.loads(resp.data), resp.duration))


r = pyneh.Requester()
r.set_connect_timeout("100ms")
r.add('http://dimon01i.yandex.ru:2222', payload="conn_timeout")
r.add('post://vla1-0169.search.yandex.net:13905/rt/', '{"signals":["myt1-0145.search.yandex.net:itype=isscacher;prj=issmsk:isscacher-saveCurrentState_xmmv"]}', payload="post")
r.add('http://ya.ru', payload="redirect")
r.add('http://dimon01i.yandex.ru', payload="conn_refused")
r.add('https://httpbin.org/delay/2', timeout=1, payload="not_ready")
r.add('https://httpbin.org/delay/2', timeout=4, payload="working")

it = r.iterate(5)
for resp in it:
    print_resp(resp)

r.add('https://httpbin.org/uuid', payload="without_iterate")
print_resp(r.wait())
